package com.wissamfawaz;

import java.time.Duration;
import java.time.Instant;
import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        int n;
        String nStr;
        Scanner scan = new Scanner(System.in);

        System.out.println("Enter an int (q to quit): ");
        nStr = scan.nextLine();

        while (!nStr.equalsIgnoreCase("q")) {
            try {
                n = Integer.parseInt(nStr);

                Instant before = Instant.now();
                System.out.println("Recursive solution: " + fibRec(n));
                Instant after = Instant.now();
                System.out.println("Running time of recursive method: " +
                        Duration.between(before, after).toMillis() + " ms.");

                before = Instant.now();
                System.out.println("Top-down DP solution: " + fibDPTopDown(n, new long[n + 1]));
                after = Instant.now();

                System.out.println("Running time of top-down dp solution: " +
                        Duration.between(before, after).toMillis() + " ms.");
                System.out.println("Bottom-up DP solution: " + fibDPBottomUp(n));

            } catch (NumberFormatException e) {
                System.out.println("Only acceptable non-int value is q");
            }

            System.out.println("Enter an int (q to quit): ");
            nStr = scan.nextLine();
        }

        scan.close();
    }

    private static long fibRec(int n) {
        // Time complexity: O(2^n), space complexity: O(n)
        if (n == 0 || n == 1) {
            return n;
        }
        return fibRec(n - 1) + fibRec(n - 2);
    }

    private static long fibDPTopDown(int n, long[] cache) {
        // Time complexity: O(n), space complexity: O(n)
        if (cache[n] != 0) {
            return cache[n];
        }

        long answer;

        if (n == 0 || n == 1) {
            answer = n;
        } else {
            answer = fibDPTopDown(n - 1, cache) + fibDPTopDown(n - 2, cache);
        }

        cache[n] = answer;

        return answer;
    }

    private static long fibDPBottomUp(int n) {
        int prevprev = 0;
        int prev = 1;
        int current = n;

        for (int i = 2; i <= n; i++) {
            current = prevprev + prev;
            prevprev = prev;
            prev = current;
        }

        return current;
    }

}
